(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    176799,       5466]
NotebookOptionsPosition[    172367,       5307]
NotebookOutlinePosition[    172711,       5322]
CellTagsIndexPosition[    172668,       5319]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solving the curvature conditions of KY tensors for the Kerr metric in four \
dimensions\
\>", "Title",
 CellChangeTimes->{{3.6163598364016523`*^9, 3.616359838351655*^9}, {
  3.6163598698916993`*^9, 3.616359890571728*^9}, {3.61635999165187*^9, 
  3.616359998391879*^9}, {3.616361114456443*^9, 3.6163611166664457`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Call the package \[OpenCurlyDoubleQuote]KY_upperbound.m\
\[CloseCurlyDoubleQuote]\
\>", "Section",
 CellChangeTimes->{{3.616358711160077*^9, 3.6163587204200897`*^9}, {
  3.616358822580233*^9, 3.6163588302302437`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "KY_upperbound.m"}]], "Input",
 CellChangeTimes->{{3.6160349780045934`*^9, 3.616034983676756*^9}, {
  3.616277931381256*^9, 3.6162779322012577`*^9}, {3.6163575512516813`*^9, 
  3.616357567141704*^9}, {3.616357871924131*^9, 3.616357872944132*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"The functions are given by kcKY[g,e,x,i,j,p] and \
kcCCKY[g,e,x,i,j,p] with a metric g_matrix, a vielbein e_matrix and a \
coordinate system x_vector,\\nwhich return Killing curvatures for vectors \
X_i, X_j and a p-form.\"\>"], "Print",
 CellChangeTimes->{
  3.6160399757702107`*^9, {3.61604011737129*^9, 3.6160401441912947`*^9}, {
   3.6160402828955965`*^9, 3.6160403279811506`*^9}, 3.6160403643424063`*^9, 
   3.6160404397827415`*^9, 3.6160405290373573`*^9, 3.616040642246338*^9, 
   3.616040710999894*^9, 3.6162779879413357`*^9, 3.616278123813527*^9, 
   3.6163575153416314`*^9, 3.6163588545702777`*^9, 3.6163625692426033`*^9, {
   3.6163626087026587`*^9, 3.6163626138926663`*^9}, 3.616362750652858*^9, 
   3.6163628363329773`*^9, 3.616364102149068*^9}],

Cell[BoxData["\<\"Enter 'helpKYupperbound' for this list of functions\"\>"], \
"Print",
 CellChangeTimes->{
  3.6160399757702107`*^9, {3.61604011737129*^9, 3.6160401441912947`*^9}, {
   3.6160402828955965`*^9, 3.6160403279811506`*^9}, 3.6160403643424063`*^9, 
   3.6160404397827415`*^9, 3.6160405290373573`*^9, 3.616040642246338*^9, 
   3.616040710999894*^9, 3.6162779879413357`*^9, 3.616278123813527*^9, 
   3.6163575153416314`*^9, 3.6163588545702777`*^9, 3.6163625692426033`*^9, {
   3.6163626087026587`*^9, 3.6163626138926663`*^9}, 3.616362750652858*^9, 
   3.6163628363329773`*^9, 3.616364102149068*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input metric data", "Section",
 CellChangeTimes->{{3.6163583186495275`*^9, 3.6163583320295463`*^9}, {
  3.6163598178216267`*^9, 3.61635982767164*^9}}],

Cell[CellGroupData[{

Cell["Input the coordinates {x^\\mu}", "Subsection",
 CellChangeTimes->{{3.616358347629568*^9, 3.6163583764496083`*^9}, {
  3.6163585045097876`*^9, 3.6163585116197977`*^9}, {3.6163591786307316`*^9, 
  3.6163591808007345`*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"coord", ":=", 
  RowBox[{"{", 
   RowBox[{"r", ",", "p", ",", "\[Tau]", ",", "\[Sigma]"}], "}"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Input the metric components g_{ab} in a frame {e^a} of T^*M\
\>", "Subsection",
 CellChangeTimes->{{3.616358454269717*^9, 3.616358476279748*^9}, {
  3.616358516069804*^9, 3.616358519009808*^9}, {3.6163585857899017`*^9, 
  3.616358621559952*^9}, {3.616358652369995*^9, 3.6163586532299957`*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell["\<\
Note: In our programme, the metric components should be constant.\
\>", "Text",
 CellChangeTimes->{3.6163586709400206`*^9},
 FontColor->GrayLevel[0]],

Cell[BoxData[
 RowBox[{"met", ":=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"-", "1"}], ",", "0"}], "}"}], "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
   "\[IndentingNewLine]", "}"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Input the vierbein e^a_\\mu, which is defined by e^a = e^a_\\mu dx^\\mu\
\>", "Subsection",
 CellChangeTimes->{{3.616358494369774*^9, 3.6163585594398646`*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"vie", ":=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", 
       SqrtBox["Q1"]], ",", "0", ",", "0", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      FractionBox["1", 
       SqrtBox["Q2"]], ",", "0", ",", "0"}], "}"}], "\[IndentingNewLine]", 
    ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      SqrtBox["Q1"], ",", 
      RowBox[{
       SqrtBox["Q1"], 
       RowBox[{"p", "^", "2"}]}]}], "}"}], "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      SqrtBox["Q2"], ",", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox["Q2"]}], 
       RowBox[{"r", "^", "2"}]}]}], "}"}]}], "\[IndentingNewLine]", 
   "}"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{"Q1", ":=", 
  FractionBox[
   RowBox[{"R", "[", "r", "]"}], 
   RowBox[{
    SuperscriptBox["r", "2"], "+", 
    SuperscriptBox["p", "2"]}]]}], "\[IndentingNewLine]", 
 RowBox[{"Q2", ":=", 
  FractionBox[
   RowBox[{"P", "[", "p", "]"}], 
   RowBox[{
    SuperscriptBox["r", "2"], "+", 
    SuperscriptBox["p", "2"]}]]}], "\n", 
 RowBox[{
  RowBox[{"R", "[", "r", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["r", "2"], "-", 
   RowBox[{"2", "M", " ", "r"}], "+", 
   SuperscriptBox["a", "2"]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "[", "p", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["a", "2"], "-", 
   SuperscriptBox["p", "2"]}]}]}], "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Killing 1-forms", "Section",
 CellChangeTimes->{{3.6163587463201265`*^9, 3.616358758360143*^9}, {
   3.61635899212047*^9, 3.6163590229705133`*^9}, 3.6163609484062104`*^9}],

Cell[CellGroupData[{

Cell["Compute the Killing curvatures", "Subsection",
 CellChangeTimes->{{3.6163592677708564`*^9, 3.6163593137209206`*^9}, 
   3.6163609407461996`*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "2", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616035346186432*^9, 3.6160353793443975`*^9}, {
   3.6160404801286125`*^9, 3.6160404825037127`*^9}, 3.6162779452912755`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6160353833602295`*^9, 3.6160401487480307`*^9, {3.616040289229145*^9, 
   3.61604033166884*^9}, 3.616040369200967*^9, 3.6160404423453736`*^9, 
   3.616040530678067*^9, 3.6160406438870497`*^9, 3.6160407126562295`*^9, 
   3.6162779892313375`*^9, 3.6162781251235285`*^9, 3.616357516581633*^9, 
   3.6163588558402796`*^9, 3.616362630072689*^9, 3.6163628376029797`*^9, 
   3.6163641034090695`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "3", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040495926305*^9, 3.6160404980826674`*^9}, 
   3.6162779478212795`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"12", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"48", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"48", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"12", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], "}"}]
    }], "}"}]], "Output",
 CellChangeTimes->{3.616040531006209*^9, 3.61604064421519*^9, 
  3.6160407129999995`*^9, 3.6162779895213375`*^9, 3.616278125423529*^9, 
  3.6163575168516335`*^9, 3.61635885614028*^9, 3.6163626303326893`*^9, 
  3.61636283788298*^9, 3.61636410369907*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "4", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405009577837`*^9, 3.6160405036923313`*^9}, 
   3.616277950481283*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405313187246`*^9, 3.616040644527706*^9, 
  3.616040713312516*^9, 3.616277989791338*^9, 3.6162781257135296`*^9, 
  3.616357517091634*^9, 3.6163588564202805`*^9, 3.6163626305726895`*^9, 
  3.6163628381329803`*^9, 3.61636410395907*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "3", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405053486404`*^9, 3.61604050816129*^9}, 
   3.6162779522512856`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405316468687`*^9, 3.6160406448402233`*^9, 
  3.616040713625031*^9, 3.6162779900613384`*^9, 3.61627812602353*^9, 
  3.6163575173416343`*^9, 3.616358856690281*^9, 3.61636263082269*^9, 
  3.6163628383929806`*^9, 3.6163641042090707`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "4", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040510161417*^9, 3.6160405147553816`*^9}, 
   3.6162779541612883`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"48", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"12", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"12", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"48", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405319593844`*^9, 3.6160406451527395`*^9, 
  3.6160407139531717`*^9, 3.616277990331339*^9, 3.616278126613531*^9, 
  3.6163575175916348`*^9, 3.616358856980281*^9, 3.6163626310726905`*^9, 
  3.6163628386429806`*^9, 3.6163641044690714`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "3", ",", "4", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405166773777`*^9, 3.61604051972441*^9}, 
   3.6162779583812943`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     FractionBox[
      RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405323344045`*^9, 3.6160406454965086`*^9, 
  3.6160407142813153`*^9, 3.6162779906013393`*^9, 3.6162781269235315`*^9, 
  3.616357517851635*^9, 3.616358857270282*^9, 3.6163626313126907`*^9, 
  3.6163628389029813`*^9, 3.6163641047290716`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Solve the curvature conditions", "Subsection",
 CellChangeTimes->{{3.616360850895074*^9, 3.616360857295083*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"var1", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solveKY", "[", 
   RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "var1"}], "]"}], "//",
   "Simplify"}]}], "Input",
 CellChangeTimes->{{3.616040607775814*^9, 3.6160406378867507`*^9}, {
  3.616040704749606*^9, 3.6160407058746643`*^9}, {3.616277970611311*^9, 
  3.616277982771328*^9}, {3.616278115373515*^9, 3.6162781187735195`*^9}, {
  3.616362558402589*^9, 3.616362562382594*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.616362632962693*^9, 3.6163627619728737`*^9, 
  3.6163628405629835`*^9, 3.616364106409074*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "5", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "7", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox[
           FractionBox[
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["p", "2"]}], 
            RowBox[{
             SuperscriptBox["p", "2"], "+", 
             SuperscriptBox["r", "2"]}]]], " ", 
          RowBox[{"a", "[", "3", "]"}]}], "+", 
         RowBox[{
          SqrtBox[
           FractionBox[
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             RowBox[{"2", " ", "M", " ", "r"}], "+", 
             SuperscriptBox["r", "2"]}], 
            RowBox[{
             SuperscriptBox["p", "2"], "+", 
             SuperscriptBox["r", "2"]}]]], " ", 
          RowBox[{"a", "[", "4", "]"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["p", "2"], "+", 
       SuperscriptBox["r", "2"]}]]}], ",", 
    RowBox[{
     RowBox[{"a", "[", "8", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox[
           FractionBox[
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["p", "2"]}], 
            RowBox[{
             SuperscriptBox["p", "2"], "+", 
             SuperscriptBox["r", "2"]}]]], " ", 
          RowBox[{"a", "[", "3", "]"}]}], "+", 
         RowBox[{
          SqrtBox[
           FractionBox[
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             RowBox[{"2", " ", "M", " ", "r"}], "+", 
             SuperscriptBox["r", "2"]}], 
            RowBox[{
             SuperscriptBox["p", "2"], "+", 
             SuperscriptBox["r", "2"]}]]], " ", 
          RowBox[{"a", "[", "4", "]"}]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["p", "2"], "+", 
       SuperscriptBox["r", "2"]}]]}], ",", 
    RowBox[{
     RowBox[{"a", "[", "10", "]"}], "\[Rule]", "0"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.616040646512185*^9, 3.616040714937599*^9, 3.6162779923913417`*^9, 
   3.616278128743534*^9, 3.616357519731638*^9, 3.616358859120284*^9, 
   3.6163596028613253`*^9, {3.6163625638525963`*^9, 3.6163625814126205`*^9}, {
   3.6163626202626753`*^9, 3.6163626330226927`*^9}, 3.6163627620328736`*^9, 
   3.616362840622984*^9, 3.6163641064690742`*^9}]
}, Open  ]],

Cell["\<\
The solution of the curvature conditions is characterised by 4 variables: \
a[3], a[4], a[6] and a[9]. This result implies that the Kerr metric admits at \
most 4 Killing 1-forms.\
\>", "Text",
 CellChangeTimes->{{3.6163647571549864`*^9, 3.6163648463971124`*^9}, {
  3.6163649669772816`*^9, 3.6163649681772833`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Killing-Yano 2-forms", "Section",
 CellChangeTimes->{{3.6163587463201265`*^9, 3.616358758360143*^9}, {
  3.61635899212047*^9, 3.6163590229705133`*^9}, {3.6163596464013863`*^9, 
  3.616359647301388*^9}, {3.616359788501585*^9, 3.6163597958315954`*^9}, {
  3.616360951926215*^9, 3.6163609595362263`*^9}}],

Cell[CellGroupData[{

Cell["Compute the Killing curvatures", "Subsection",
 CellChangeTimes->{{3.6163592677708564`*^9, 3.6163593137209206`*^9}, 
   3.616362501362509*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "2", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616035346186432*^9, 3.6160353793443975`*^9}, {
   3.6160404801286125`*^9, 3.6160404825037127`*^9}, 3.6162779452912755`*^9, {
   3.6163596647214117`*^9, 3.6163596648514123`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", "0", ",", "0", 
     ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",",
      "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", "0", ",", "0", 
     ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6160353833602295`*^9, 3.6160401487480307`*^9, {3.616040289229145*^9, 
   3.61604033166884*^9}, 3.616040369200967*^9, 3.6160404423453736`*^9, 
   3.616040530678067*^9, 3.6160406438870497`*^9, 3.6160407126562295`*^9, 
   3.6162779892313375`*^9, 3.6162781251235285`*^9, 3.616357516581633*^9, 
   3.6163588558402796`*^9, 3.616359709021474*^9, 3.616362841802985*^9, 
   3.6163641076690755`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "3", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040495926305*^9, 3.6160404980826674`*^9}, 
   3.6162779478212795`*^9, 3.6163596671814156`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"], " ", "r"}], "+", 
          SuperscriptBox["r", "3"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"], " ", "r"}], "+", 
          SuperscriptBox["r", "3"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",",
      "0", ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"36", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"36", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.616040531006209*^9, 3.61604064421519*^9, 
  3.6160407129999995`*^9, 3.6162779895213375`*^9, 3.616278125423529*^9, 
  3.6163575168516335`*^9, 3.61635885614028*^9, 3.616359710111476*^9, 
  3.616362842872987*^9, 3.616364108739077*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "4", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405009577837`*^9, 3.6160405036923313`*^9}, 
   3.616277950481283*^9, 3.6163596696414185`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405313187246`*^9, 3.616040644527706*^9, 
  3.616040713312516*^9, 3.616277989791338*^9, 3.6162781257135296`*^9, 
  3.616357517091634*^9, 3.6163588564202805`*^9, 3.616359711201477*^9, 
  3.6163628439429884`*^9, 3.6163641098090787`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "3", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405053486404`*^9, 3.61604050816129*^9}, 
   3.6162779522512856`*^9, 3.616359671751422*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405316468687`*^9, 3.6160406448402233`*^9, 
  3.616040713625031*^9, 3.6162779900613384`*^9, 3.61627812602353*^9, 
  3.6163575173416343`*^9, 3.616358856690281*^9, 3.6163597122914786`*^9, 
  3.61636284501299*^9, 3.6163641108790803`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "4", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040510161417*^9, 3.6160405147553816`*^9}, 
   3.6162779541612883`*^9, 3.616359673771425*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"], " ", "r"}], "+", 
          SuperscriptBox["r", "3"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"9", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"36", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"36", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405319593844`*^9, 3.6160406451527395`*^9, 
  3.6160407139531717`*^9, 3.616277990331339*^9, 3.616278126613531*^9, 
  3.6163575175916348`*^9, 3.616358856980281*^9, 3.61635971341148*^9, 
  3.6163628460729914`*^9, 3.6163641119590816`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "3", ",", "4", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405166773777`*^9, 3.61604051972441*^9}, 
   3.6162779583812943`*^9, 3.6163596758614273`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           RowBox[{"2", " ", "M", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", "0", ",", "0", 
     ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          SuperscriptBox["r", "2"]}], ")"}], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]]}], ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]], ",", "0", ",", "0", ",",
      "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["p", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "4"], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["p", "2"], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          SuperscriptBox["r", "4"]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "4"]}]]}], ",", "0", ",", "0", 
     ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "4"], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         SuperscriptBox["r", "4"]}], ")"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "4"]}]], ",", "0", ",", "0", ",",
      "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"18", " ", "M", " ", "p", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         SuperscriptBox["r", "2"]}], ")"}], " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "4"]], ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "3"]}]]}], ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405323344045`*^9, 3.6160406454965086`*^9, 
  3.6160407142813153`*^9, 3.6162779906013393`*^9, 3.6162781269235315`*^9, 
  3.616357517851635*^9, 3.616358857270282*^9, 3.6163597145114813`*^9, 
  3.616362847142993*^9, 3.6163641130290833`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Solve the curvature conditions", "Subsection",
 CellChangeTimes->{{3.616362512862525*^9, 3.616362518092532*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"var2", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solveKY", "[", 
   RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "var2"}], "]"}], "//",
   "Simplify"}]}], "Input",
 CellChangeTimes->{{3.616040607775814*^9, 3.6160406378867507`*^9}, {
  3.616040704749606*^9, 3.6160407058746643`*^9}, {3.616277970611311*^9, 
  3.616277982771328*^9}, {3.616278115373515*^9, 3.6162781187735195`*^9}, {
  3.616362550152577*^9, 3.6163625560825853`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6163626469827127`*^9, 3.6163627724428883`*^9, 
  3.6163628541230025`*^9, 3.616364119999093*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "3", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "4", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "5", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"r", " ", 
       RowBox[{"a", "[", "2", "]"}]}], "p"]}], ",", 
    RowBox[{
     RowBox[{"a", "[", "6", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "7", "]"}], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["p", "2"]}], 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}]]], " ", 
        RowBox[{"a", "[", "2", "]"}]}], "p"]}]}], ",", 
    RowBox[{
     RowBox[{"a", "[", "8", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          RowBox[{"2", " ", "M", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}]]], " ", 
       RowBox[{"a", "[", "2", "]"}]}], "p"]}], ",", 
    RowBox[{
     RowBox[{"a", "[", "9", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "10", "]"}], "\[Rule]", "0"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6163626470027122`*^9, 3.6163627724628887`*^9, 
  3.6163628541330023`*^9, 3.6163641200090933`*^9}]
}, Open  ]],

Cell["\<\
The solution of the curvature conditions is characterised by the only \
variable a[2]. This result implies that the Kerr metric admits at most 1 \
Killing-Yano 2-form.\
\>", "Text",
 CellChangeTimes->{{3.616364896137182*^9, 3.6163649419072466`*^9}, {
  3.6163649728272896`*^9, 3.6163649935773187`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Killing-Yano 3-forms", "Section",
 CellChangeTimes->{{3.6163587463201265`*^9, 3.616358758360143*^9}, {
   3.61635899212047*^9, 3.6163590229705133`*^9}, {3.616359653991397*^9, 
   3.616359654201397*^9}, 3.616359793601592*^9, {3.616360954016218*^9, 
   3.6163609654362345`*^9}}],

Cell[CellGroupData[{

Cell["Compute the Killing curvatures", "Subsection",
 CellChangeTimes->{{3.6163592677708564`*^9, 3.6163593137209206`*^9}, 
   3.6163628273529654`*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "2", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616035346186432*^9, 3.6160353793443975`*^9}, {
   3.6160404801286125`*^9, 3.6160404825037127`*^9}, 3.6162779452912755`*^9, 
   3.6163596871614437`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6160353833602295`*^9, 3.6160401487480307`*^9, {3.616040289229145*^9, 
   3.61604033166884*^9}, 3.616040369200967*^9, 3.6160404423453736`*^9, 
   3.616040530678067*^9, 3.6160406438870497`*^9, 3.6160407126562295`*^9, 
   3.6162779892313375`*^9, 3.6162781251235285`*^9, 3.616357516581633*^9, 
   3.6163588558402796`*^9, 3.6163597336115084`*^9, 3.6163628618530135`*^9, 
   3.6163641277991037`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "3", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040495926305*^9, 3.6160404980826674`*^9}, 
   3.6162779478212795`*^9, 3.6163596893214464`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.616040531006209*^9, 3.61604064421519*^9, 
  3.6160407129999995`*^9, 3.6162779895213375`*^9, 3.616278125423529*^9, 
  3.6163575168516335`*^9, 3.61635885614028*^9, 3.616359741371519*^9, 
  3.616362869543024*^9, 3.6163641355091147`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "4", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405009577837`*^9, 3.6160405036923313`*^9}, 
   3.616277950481283*^9, 3.6163596914514494`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0", ",",
      "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405313187246`*^9, 3.616040644527706*^9, 
  3.616040713312516*^9, 3.616277989791338*^9, 3.6162781257135296`*^9, 
  3.616357517091634*^9, 3.6163588564202805`*^9, 3.61635974910153*^9, 
  3.616362877243035*^9, 3.6163641432191257`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "3", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405053486404`*^9, 3.61604050816129*^9}, 
   3.6162779522512856`*^9, 3.616359695231455*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"M", " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["p", "2"]}], "+", 
          SuperscriptBox["r", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0", ",",
      "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0", ",",
      "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405316468687`*^9, 3.6160406448402233`*^9, 
  3.616040713625031*^9, 3.6162779900613384`*^9, 3.61627812602353*^9, 
  3.6163575173416343`*^9, 3.616358856690281*^9, 3.616359756801541*^9, 
  3.616362884953046*^9, 3.6163641509091363`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "4", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040510161417*^9, 3.6160405147553816`*^9}, 
   3.6162779541612883`*^9, 3.6163596978014584`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["p", "2"], " ", "r"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"2", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"2", " ", "M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405319593844`*^9, 3.6160406451527395`*^9, 
  3.6160407139531717`*^9, 3.616277990331339*^9, 3.616278126613531*^9, 
  3.6163575175916348`*^9, 3.616358856980281*^9, 3.6163597644915514`*^9, 
  3.6163628926430564`*^9, 3.6163641586191473`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "3", ",", "4", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405166773777`*^9, 3.61604051972441*^9}, 
   3.6162779583812943`*^9, 3.616359700291462*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"M", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox["r", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0", ",", "0", ",", 
     "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"M", " ", "p", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["p", "2"], "+", 
         SuperscriptBox["r", "2"]}], ")"}], "3"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"M", " ", "p", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["p", "2"], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "3"]]}], ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405323344045`*^9, 3.6160406454965086`*^9, 
  3.6160407142813153`*^9, 3.6162779906013393`*^9, 3.6162781269235315`*^9, 
  3.616357517851635*^9, 3.616358857270282*^9, 3.6163597722715626`*^9, 
  3.616362900373067*^9, 3.616364166329158*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Solve the curvature conditions", "Subsection",
 CellChangeTimes->{{3.616362512862525*^9, 3.616362518092532*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"var3", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solveKY", "[", 
   RowBox[{"met", ",", "vie", ",", "coord", ",", "3", ",", "var3"}], "]"}], "//",
   "Simplify"}]}], "Input",
 CellChangeTimes->{{3.616040607775814*^9, 3.6160406378867507`*^9}, {
  3.616040704749606*^9, 3.6160407058746643`*^9}, {3.616277970611311*^9, 
  3.616277982771328*^9}, {3.616278115373515*^9, 3.6162781187735195`*^9}, {
  3.616362550152577*^9, 3.6163625560825853`*^9}, {3.6163626776927557`*^9, 
  3.6163627118928037`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6163628232629595`*^9, 3.6163629466231318`*^9, 
  3.6163642125792227`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "3", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "4", "]"}], "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6163628232629595`*^9, 3.6163629466231318`*^9, 
  3.6163642125792227`*^9}]
}, Open  ]],

Cell["\<\
The dimension of the kernel is given by one. However, this result implies \
that the Kerr metric admits no Killing-Yano 3-form.\
\>", "Text",
 CellChangeTimes->{{3.616365009367341*^9, 3.6163650656274195`*^9}, {
  3.6168756990835342`*^9, 3.616875844918964*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1904, 1064},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 28, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 327, 6, 144, "Title"],
Cell[CellGroupData[{
Cell[931, 32, 227, 5, 79, "Section"],
Cell[CellGroupData[{
Cell[1183, 41, 275, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[1483, 49, 775, 11, 43, "Print"],
Cell[2261, 62, 607, 9, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2929, 78, 156, 2, 79, "Section"],
Cell[CellGroupData[{
Cell[3110, 84, 264, 4, 65, "Subsection"],
Cell[3377, 90, 133, 3, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3547, 98, 341, 6, 65, "Subsection"],
Cell[3891, 106, 159, 4, 30, "Text"],
Cell[4053, 112, 554, 15, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4644, 132, 207, 4, 65, "Subsection"],
Cell[4854, 138, 812, 27, 208, "Input"],
Cell[5669, 167, 683, 23, 130, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[6401, 196, 177, 2, 49, "Section"],
Cell[CellGroupData[{
Cell[6603, 202, 188, 3, 59, "Subsection"],
Cell[CellGroupData[{
Cell[6816, 209, 277, 5, 31, "Input"],
Cell[7096, 216, 9016, 270, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16149, 491, 227, 5, 31, "Input"],
Cell[16379, 498, 13079, 400, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29495, 903, 227, 5, 31, "Input"],
Cell[29725, 910, 8798, 265, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38560, 1180, 226, 5, 31, "Input"],
Cell[38789, 1187, 8794, 265, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47620, 1457, 227, 5, 31, "Input"],
Cell[47850, 1464, 13041, 399, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60928, 1868, 226, 5, 31, "Input"],
Cell[61157, 1875, 8779, 265, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[69985, 2146, 156, 2, 51, "Subsection"],
Cell[CellGroupData[{
Cell[70166, 2152, 618, 14, 52, "Input"],
Cell[70787, 2168, 515, 10, 22, "Message"],
Cell[71305, 2180, 2682, 78, 80, "Output"]
}, Open  ]],
Cell[74002, 2261, 326, 6, 30, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74377, 2273, 307, 4, 79, "Section"],
Cell[CellGroupData[{
Cell[74709, 2281, 186, 3, 59, "Subsection"],
Cell[CellGroupData[{
Cell[74920, 2288, 331, 6, 31, "Input"],
Cell[75254, 2296, 10970, 334, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86261, 2635, 251, 5, 31, "Input"],
Cell[86515, 2642, 15099, 466, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101651, 3113, 251, 5, 31, "Input"],
Cell[101905, 3120, 10910, 335, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112852, 3460, 248, 5, 31, "Input"],
Cell[113103, 3467, 10912, 335, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[124052, 3807, 249, 5, 31, "Input"],
Cell[124304, 3814, 15078, 465, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139419, 4284, 250, 5, 31, "Input"],
Cell[139672, 4291, 10725, 328, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150446, 4625, 156, 2, 51, "Subsection"],
Cell[CellGroupData[{
Cell[150627, 4631, 620, 14, 52, "Input"],
Cell[151250, 4647, 517, 10, 22, "Message"],
Cell[151770, 4659, 1667, 51, 76, "Output"]
}, Open  ]],
Cell[153452, 4713, 312, 6, 30, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153813, 4725, 282, 4, 79, "Section"],
Cell[CellGroupData[{
Cell[154120, 4733, 188, 3, 59, "Subsection"],
Cell[CellGroupData[{
Cell[154333, 4740, 305, 6, 31, "Input"],
Cell[154641, 4748, 2454, 74, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157132, 4827, 251, 5, 31, "Input"],
Cell[157386, 4834, 2320, 71, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159743, 4910, 251, 5, 31, "Input"],
Cell[159997, 4917, 2358, 73, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162392, 4995, 248, 5, 31, "Input"],
Cell[162643, 5002, 2361, 73, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165041, 5080, 251, 5, 31, "Input"],
Cell[165295, 5087, 2300, 70, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167632, 5162, 248, 5, 31, "Input"],
Cell[167883, 5169, 2296, 71, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[170228, 5246, 156, 2, 51, "Subsection"],
Cell[CellGroupData[{
Cell[170409, 5252, 672, 15, 52, "Input"],
Cell[171084, 5269, 495, 10, 22, "Message"],
Cell[171582, 5281, 460, 13, 31, "Output"]
}, Open  ]],
Cell[172057, 5297, 270, 5, 30, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
