(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     63273,       1870]
NotebookOptionsPosition[     58919,       1711]
NotebookOutlinePosition[     59263,       1726]
CellTagsIndexPosition[     59220,       1723]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solving the curvature conditions of KY tensors for the Schwarzschild metric \
in four dimensions\
\>", "Title",
 CellChangeTimes->{{3.6163598364016523`*^9, 3.616359838351655*^9}, {
  3.6163598698916993`*^9, 3.616359890571728*^9}, {3.61635999165187*^9, 
  3.616359998391879*^9}, {3.616361114456443*^9, 3.6163611166664457`*^9}, {
  3.6163632113328185`*^9, 3.6163632151828237`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Call the package \[OpenCurlyDoubleQuote]KY_upperbound.m\
\[CloseCurlyDoubleQuote]\
\>", "Section",
 CellChangeTimes->{{3.616358711160077*^9, 3.6163587204200897`*^9}, {
  3.616358822580233*^9, 3.6163588302302437`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "KY_upperbound.m"}]], "Input",
 CellChangeTimes->{{3.6160349780045934`*^9, 3.616034983676756*^9}, {
  3.616277931381256*^9, 3.6162779322012577`*^9}, {3.6163575512516813`*^9, 
  3.616357567141704*^9}, {3.616357871924131*^9, 3.616357872944132*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"The functions are given by kcKY[g,e,x,i,j,p] and \
kcCCKY[g,e,x,i,j,p] with a metric g_matrix, a vielbein e_matrix and a \
coordinate system x_vector,\\nwhich return Killing curvatures for vectors \
X_i, X_j and a p-form.\"\>"], "Print",
 CellChangeTimes->{
  3.6160399757702107`*^9, {3.61604011737129*^9, 3.6160401441912947`*^9}, {
   3.6160402828955965`*^9, 3.6160403279811506`*^9}, 3.6160403643424063`*^9, 
   3.6160404397827415`*^9, 3.6160405290373573`*^9, 3.616040642246338*^9, 
   3.616040710999894*^9, 3.6162779879413357`*^9, 3.616278123813527*^9, 
   3.6163575153416314`*^9, 3.6163588545702777`*^9, 3.6163625692426033`*^9, {
   3.6163626087026587`*^9, 3.6163626138926663`*^9}, 3.616362750652858*^9, 
   3.6163628363329773`*^9, 3.616363404743089*^9}],

Cell[BoxData["\<\"Enter 'helpKYupperbound' for this list of functions\"\>"], \
"Print",
 CellChangeTimes->{
  3.6160399757702107`*^9, {3.61604011737129*^9, 3.6160401441912947`*^9}, {
   3.6160402828955965`*^9, 3.6160403279811506`*^9}, 3.6160403643424063`*^9, 
   3.6160404397827415`*^9, 3.6160405290373573`*^9, 3.616040642246338*^9, 
   3.616040710999894*^9, 3.6162779879413357`*^9, 3.616278123813527*^9, 
   3.6163575153416314`*^9, 3.6163588545702777`*^9, 3.6163625692426033`*^9, {
   3.6163626087026587`*^9, 3.6163626138926663`*^9}, 3.616362750652858*^9, 
   3.6163628363329773`*^9, 3.616363404743089*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input metric data", "Section",
 CellChangeTimes->{{3.6163583186495275`*^9, 3.6163583320295463`*^9}, {
  3.6163598178216267`*^9, 3.61635982767164*^9}}],

Cell[CellGroupData[{

Cell["Input the coordinates {x^\\mu}", "Subsection",
 CellChangeTimes->{{3.616358347629568*^9, 3.6163583764496083`*^9}, {
  3.6163585045097876`*^9, 3.6163585116197977`*^9}, {3.6163591786307316`*^9, 
  3.6163591808007345`*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"coord", ":=", 
  RowBox[{"{", 
   RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.616363238292856*^9, 3.616363244592865*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Input the metric components g_{ab} in a frame {e^a} of T^*M\
\>", "Subsection",
 CellChangeTimes->{{3.616358454269717*^9, 3.616358476279748*^9}, {
  3.616358516069804*^9, 3.616358519009808*^9}, {3.6163585857899017`*^9, 
  3.616358621559952*^9}, {3.616358652369995*^9, 3.6163586532299957`*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell["\<\
Note: In our programme, the metric components should be constant.\
\>", "Text",
 CellChangeTimes->{3.6163586709400206`*^9},
 FontColor->GrayLevel[0]],

Cell[BoxData[
 RowBox[{"met", ":=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
   "\[IndentingNewLine]", "}"}]}]], "Input",
 CellChangeTimes->{{3.6163632492128716`*^9, 3.6163632520428753`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Input the vierbein e^a_\\mu, which is defined by e^a = e^a_\\mu dx^\\mu\
\>", "Subsection",
 CellChangeTimes->{{3.616358494369774*^9, 3.6163585594398646`*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[BoxData[
 RowBox[{"vie", ":=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "r", "]"}]], ",", "0", ",", "0", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"f", "[", "r", "]"}]]], ",", "0", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "r", ",", "0"}], "}"}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"r", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}]}], 
   "\[IndentingNewLine]", "}"}]}]], "Input",
 CellChangeTimes->{{3.6163632589528847`*^9, 3.616363309702956*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "r", "]"}], ":=", 
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"2", "M"}], "r"]}]}]], "Input",
 CellChangeTimes->{{3.6163633207729716`*^9, 3.616363332662988*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Killing 1-forms", "Section",
 CellChangeTimes->{{3.6163587463201265`*^9, 3.616358758360143*^9}, {
   3.61635899212047*^9, 3.6163590229705133`*^9}, 3.6163609484062104`*^9}],

Cell[CellGroupData[{

Cell["Compute the Killing curvatures", "Subsection",
 CellChangeTimes->{{3.6163592677708564`*^9, 3.6163593137209206`*^9}, 
   3.6163609407461996`*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "2", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616035346186432*^9, 3.6160353793443975`*^9}, {
   3.6160404801286125`*^9, 3.6160404825037127`*^9}, 3.6162779452912755`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"12", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       SuperscriptBox["r", "4"]]}], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6160353833602295`*^9, 3.6160401487480307`*^9, {3.616040289229145*^9, 
   3.61604033166884*^9}, 3.616040369200967*^9, 3.6160404423453736`*^9, 
   3.616040530678067*^9, 3.6160406438870497`*^9, 3.6160407126562295`*^9, 
   3.6162779892313375`*^9, 3.6162781251235285`*^9, 3.616357516581633*^9, 
   3.6163588558402796`*^9, 3.616362630072689*^9, 3.6163628376029797`*^9, 
   3.61636340504309*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "3", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040495926305*^9, 3.6160404980826674`*^9}, 
   3.6162779478212795`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      SuperscriptBox["r", "3"]], ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.616040531006209*^9, 3.61604064421519*^9, 
  3.6160407129999995`*^9, 3.6162779895213375`*^9, 3.616278125423529*^9, 
  3.6163575168516335`*^9, 3.61635885614028*^9, 3.6163626303326893`*^9, 
  3.61636283788298*^9, 3.6163634051430893`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "4", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405009577837`*^9, 3.6160405036923313`*^9}, 
   3.616277950481283*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405313187246`*^9, 3.616040644527706*^9, 
  3.616040713312516*^9, 3.616277989791338*^9, 3.6162781257135296`*^9, 
  3.616357517091634*^9, 3.6163588564202805`*^9, 3.6163626305726895`*^9, 
  3.6163628381329803`*^9, 3.6163634052430897`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "3", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405053486404`*^9, 3.61604050816129*^9}, 
   3.6162779522512856`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       SuperscriptBox["r", "4"]]}], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       SuperscriptBox["r", "4"]]}], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      SuperscriptBox["r", "3"]], ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405316468687`*^9, 3.6160406448402233`*^9, 
  3.616040713625031*^9, 3.6162779900613384`*^9, 3.61627812602353*^9, 
  3.6163575173416343`*^9, 3.616358856690281*^9, 3.61636263082269*^9, 
  3.6163628383929806`*^9, 3.61636340533309*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "4", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040510161417*^9, 3.6160405147553816`*^9}, 
   3.6162779541612883`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       SuperscriptBox["r", "4"]]}], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405319593844`*^9, 3.6160406451527395`*^9, 
  3.6160407139531717`*^9, 3.616277990331339*^9, 3.616278126613531*^9, 
  3.6163575175916348`*^9, 3.616358856980281*^9, 3.6163626310726905`*^9, 
  3.6163628386429806`*^9, 3.61636340543309*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "3", ",", "4", ",", "1"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405166773777`*^9, 3.61604051972441*^9}, 
   3.6162779583812943`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      SuperscriptBox["r", "3"]], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"6", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       SuperscriptBox["r", "4"]]}], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      SuperscriptBox["r", "3"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"6", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"12", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405323344045`*^9, 3.6160406454965086`*^9, 
  3.6160407142813153`*^9, 3.6162779906013393`*^9, 3.6162781269235315`*^9, 
  3.616357517851635*^9, 3.616358857270282*^9, 3.6163626313126907`*^9, 
  3.6163628389029813`*^9, 3.61636340553309*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Solve the curvature conditions", "Subsection",
 CellChangeTimes->{{3.616360850895074*^9, 3.616360857295083*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"var1", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solveKY", "[", 
   RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "var1"}], "]"}], "//",
   "Simplify"}]}], "Input",
 CellChangeTimes->{{3.616040607775814*^9, 3.6160406378867507`*^9}, {
  3.616040704749606*^9, 3.6160407058746643`*^9}, {3.616277970611311*^9, 
  3.616277982771328*^9}, {3.616278115373515*^9, 3.6162781187735195`*^9}, {
  3.616362558402589*^9, 3.616362562382594*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.616362632962693*^9, 3.6163627619728737`*^9, 
  3.6163628405629835`*^9, 3.6163634061930914`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "6", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "7", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "8", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]], " ", 
       RowBox[{"a", "[", "3", "]"}]}], "r"]}], ",", 
    RowBox[{
     RowBox[{"a", "[", "9", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]], " ", 
       RowBox[{"a", "[", "4", "]"}]}], "r"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.616040646512185*^9, 3.616040714937599*^9, 3.6162779923913417`*^9, 
   3.616278128743534*^9, 3.616357519731638*^9, 3.616358859120284*^9, 
   3.6163596028613253`*^9, {3.6163625638525963`*^9, 3.6163625814126205`*^9}, {
   3.6163626202626753`*^9, 3.6163626330226927`*^9}, 3.6163627620328736`*^9, 
   3.616362840622984*^9, 3.616363406203091*^9}]
}, Open  ]],

Cell["\<\
The solution of the curvature conditions is characterised by 5 variables: \
a[1], a[3], a[4], a[5] and a[10]. This result implies that the Schwarzschild \
metric admits at most 5 Killing 1-forms.\
\>", "Text",
 CellChangeTimes->{{3.6163651976676044`*^9, 3.6163652611376934`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Killing-Yano 2-forms", "Section",
 CellChangeTimes->{{3.6163587463201265`*^9, 3.616358758360143*^9}, {
  3.61635899212047*^9, 3.6163590229705133`*^9}, {3.6163596464013863`*^9, 
  3.616359647301388*^9}, {3.616359788501585*^9, 3.6163597958315954`*^9}, {
  3.616360951926215*^9, 3.6163609595362263`*^9}}],

Cell[CellGroupData[{

Cell["Compute the Killing curvatures", "Subsection",
 CellChangeTimes->{{3.6163592677708564`*^9, 3.6163593137209206`*^9}, 
   3.616362501362509*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "2", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616035346186432*^9, 3.6160353793443975`*^9}, {
   3.6160404801286125`*^9, 3.6160404825037127`*^9}, 3.6162779452912755`*^9, {
   3.6163596647214117`*^9, 3.6163596648514123`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "4"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "4"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      SuperscriptBox["r", "4"]], ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6160353833602295`*^9, 3.6160401487480307`*^9, {3.616040289229145*^9, 
   3.61604033166884*^9}, 3.616040369200967*^9, 3.6160404423453736`*^9, 
   3.616040530678067*^9, 3.6160406438870497`*^9, 3.6160407126562295`*^9, 
   3.6162779892313375`*^9, 3.6162781251235285`*^9, 3.616357516581633*^9, 
   3.6163588558402796`*^9, 3.616359709021474*^9, 3.616362841802985*^9, 
   3.616363406893092*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "3", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040495926305*^9, 3.6160404980826674`*^9}, 
   3.6162779478212795`*^9, 3.6163596671814156`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}]], ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.616040531006209*^9, 3.61604064421519*^9, 
  3.6160407129999995`*^9, 3.6162779895213375`*^9, 3.616278125423529*^9, 
  3.6163575168516335`*^9, 3.61635885614028*^9, 3.616359710111476*^9, 
  3.616362842872987*^9, 3.616363407533093*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "4", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405009577837`*^9, 3.6160405036923313`*^9}, 
   3.616277950481283*^9, 3.6163596696414185`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "4"]}]]}], ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "4"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}]], ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405313187246`*^9, 3.616040644527706*^9, 
  3.616040713312516*^9, 3.616277989791338*^9, 3.6162781257135296`*^9, 
  3.616357517091634*^9, 3.6163588564202805`*^9, 3.616359711201477*^9, 
  3.6163628439429884`*^9, 3.616363408183094*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "3", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405053486404`*^9, 3.61604050816129*^9}, 
   3.6162779522512856`*^9, 3.616359671751422*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405316468687`*^9, 3.6160406448402233`*^9, 
  3.616040713625031*^9, 3.6162779900613384`*^9, 3.61627812602353*^9, 
  3.6163575173416343`*^9, 3.616358856690281*^9, 3.6163597122914786`*^9, 
  3.61636284501299*^9, 3.616363408823095*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "4", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040510161417*^9, 3.6160405147553816`*^9}, 
   3.6162779541612883`*^9, 3.616359673771425*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "4"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405319593844`*^9, 3.6160406451527395`*^9, 
  3.6160407139531717`*^9, 3.616277990331339*^9, 3.616278126613531*^9, 
  3.6163575175916348`*^9, 3.616358856980281*^9, 3.61635971341148*^9, 
  3.6163628460729914`*^9, 3.616363409473096*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "3", ",", "4", ",", "2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405166773777`*^9, 3.61604051972441*^9}, 
   3.6162779583812943`*^9, 3.6163596758614273`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox[
      RowBox[{"9", " ", "M", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"]}]], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", 
     FractionBox[
      RowBox[{"3", " ", "M"}], 
      SuperscriptBox["r", "3"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "4"]}]]}], ",", "0", ",", "0", ",", "0", ",", "0",
      ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"3", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"9", " ", "M", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", " ", "M"}], "r"]}]]}], 
       SuperscriptBox["r", "4"]]}], ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6160405323344045`*^9, 3.6160406454965086`*^9, 
  3.6160407142813153`*^9, 3.6162779906013393`*^9, 3.6162781269235315`*^9, 
  3.616357517851635*^9, 3.616358857270282*^9, 3.6163597145114813`*^9, 
  3.616362847142993*^9, 3.6163634101230965`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Solve the curvature conditions", "Subsection",
 CellChangeTimes->{{3.616362512862525*^9, 3.616362518092532*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"var2", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solveKY", "[", 
   RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "var2"}], "]"}], "//",
   "Simplify"}]}], "Input",
 CellChangeTimes->{{3.616040607775814*^9, 3.6160406378867507`*^9}, {
  3.616040704749606*^9, 3.6160407058746643`*^9}, {3.616277970611311*^9, 
  3.616277982771328*^9}, {3.616278115373515*^9, 3.6162781187735195`*^9}, {
  3.616362550152577*^9, 3.6163625560825853`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6163626469827127`*^9, 3.6163627724428883`*^9, 
  3.6163628541230025`*^9, 3.616363413873102*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "3", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "4", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "5", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "7", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "8", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "9", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "10", "]"}], "\[Rule]", 
     FractionBox[
      RowBox[{"3", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", " ", "M"}], "r"]}]], " ", 
       RowBox[{"a", "[", "6", "]"}]}], "r"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6163626470027122`*^9, 3.6163627724628887`*^9, 
  3.6163628541330023`*^9, 3.616363413883102*^9}]
}, Open  ]],

Cell["\<\
The solution of the curvature conditions is characterised by the only \
variable a[6]. This result implies that the Schwarzschild metric admits at \
most 1 Killing-Yano 2-form.\
\>", "Text",
 CellChangeTimes->{{3.616365280967721*^9, 3.616365304467754*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Killing-Yano 3-forms", "Section",
 CellChangeTimes->{{3.6163587463201265`*^9, 3.616358758360143*^9}, {
   3.61635899212047*^9, 3.6163590229705133`*^9}, {3.616359653991397*^9, 
   3.616359654201397*^9}, 3.616359793601592*^9, {3.616360954016218*^9, 
   3.6163609654362345`*^9}}],

Cell[CellGroupData[{

Cell["Compute the Killing curvatures", "Subsection",
 CellChangeTimes->{{3.6163592677708564`*^9, 3.6163593137209206`*^9}, 
   3.6163628273529654`*^9},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "2", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616035346186432*^9, 3.6160353793443975`*^9}, {
   3.6160404801286125`*^9, 3.6160404825037127`*^9}, 3.6162779452912755`*^9, 
   3.6163596871614437`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6160353833602295`*^9, 3.6160401487480307`*^9, {3.616040289229145*^9, 
   3.61604033166884*^9}, 3.616040369200967*^9, 3.6160404423453736`*^9, 
   3.616040530678067*^9, 3.6160406438870497`*^9, 3.6160407126562295`*^9, 
   3.6162779892313375`*^9, 3.6162781251235285`*^9, 3.616357516581633*^9, 
   3.6163588558402796`*^9, 3.6163597336115084`*^9, 3.6163628618530135`*^9, 
   3.6163634205631113`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "3", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040495926305*^9, 3.6160404980826674`*^9}, 
   3.6162779478212795`*^9, 3.6163596893214464`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["M", 
       SuperscriptBox["r", "3"]]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", 
      FractionBox["M", 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.616040531006209*^9, 3.61604064421519*^9, 
  3.6160407129999995`*^9, 3.6162779895213375`*^9, 3.616278125423529*^9, 
  3.6163575168516335`*^9, 3.61635885614028*^9, 3.616359741371519*^9, 
  3.616362869543024*^9, 3.61636342720312*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "1", ",", "4", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405009577837`*^9, 3.6160405036923313`*^9}, 
   3.616277950481283*^9, 3.6163596914514494`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     FractionBox["M", 
      SuperscriptBox["r", "3"]], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["M", 
      SuperscriptBox["r", "3"]], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405313187246`*^9, 3.616040644527706*^9, 
  3.616040713312516*^9, 3.616277989791338*^9, 3.6162781257135296`*^9, 
  3.616357517091634*^9, 3.6163588564202805`*^9, 3.61635974910153*^9, 
  3.616362877243035*^9, 3.6163634338531303`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "3", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405053486404`*^9, 3.61604050816129*^9}, 
   3.6162779522512856`*^9, 3.616359695231455*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["M", 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["M", 
      SuperscriptBox["r", "3"]], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405316468687`*^9, 3.6160406448402233`*^9, 
  3.616040713625031*^9, 3.6162779900613384`*^9, 3.61627812602353*^9, 
  3.6163575173416343`*^9, 3.616358856690281*^9, 3.616359756801541*^9, 
  3.616362884953046*^9, 3.616363440563139*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "2", ",", "4", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616040510161417*^9, 3.6160405147553816`*^9}, 
   3.6162779541612883`*^9, 3.6163596978014584`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["M", 
      SuperscriptBox["r", "3"]], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["M", 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405319593844`*^9, 3.6160406451527395`*^9, 
  3.6160407139531717`*^9, 3.616277990331339*^9, 3.616278126613531*^9, 
  3.6163575175916348`*^9, 3.616358856980281*^9, 3.6163597644915514`*^9, 
  3.6163628926430564`*^9, 3.6163634472131486`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kcKY", "[", 
  RowBox[{"met", ",", "vie", ",", "coord", ",", "3", ",", "4", ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6160405166773777`*^9, 3.61604051972441*^9}, 
   3.6162779583812943`*^9, 3.616359700291462*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox[
      RowBox[{"2", " ", "M"}], 
      SuperscriptBox["r", "3"]], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "M"}], 
       SuperscriptBox["r", "3"]]}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6160405323344045`*^9, 3.6160406454965086`*^9, 
  3.6160407142813153`*^9, 3.6162779906013393`*^9, 3.6162781269235315`*^9, 
  3.616357517851635*^9, 3.616358857270282*^9, 3.6163597722715626`*^9, 
  3.616362900373067*^9, 3.616363453853158*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Solve the curvature conditions", "Subsection",
 CellChangeTimes->{{3.616362512862525*^9, 3.616362518092532*^9}},
 Background->RGBColor[0.87, 0.94, 1]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"var3", ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"a", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solveKY", "[", 
   RowBox[{"met", ",", "vie", ",", "coord", ",", "3", ",", "var3"}], "]"}], "//",
   "Simplify"}]}], "Input",
 CellChangeTimes->{{3.616040607775814*^9, 3.6160406378867507`*^9}, {
  3.616040704749606*^9, 3.6160407058746643`*^9}, {3.616277970611311*^9, 
  3.616277982771328*^9}, {3.616278115373515*^9, 3.6162781187735195`*^9}, {
  3.616362550152577*^9, 3.6163625560825853`*^9}, {3.6163626776927557`*^9, 
  3.6163627118928037`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Solve", "::", "svars"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Equations may not give solutions for all \\\"solve\\\" \
variables. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6163628232629595`*^9, 3.6163629466231318`*^9, 
  3.6163634936732135`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "2", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "3", "]"}], "\[Rule]", "0"}], ",", 
    RowBox[{
     RowBox[{"a", "[", "4", "]"}], "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.6163628232629595`*^9, 3.6163629466231318`*^9, 
  3.6163634936732135`*^9}]
}, Open  ]],

Cell["\<\
The curvature conditions do not have any solution. This result implies that \
the Schwarzschild metric admits no Killing-Yano 3-form.\
\>", "Text",
 CellChangeTimes->{{3.61636531610777*^9, 3.616365345347811*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1904, 1064},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"9.0 for Microsoft Windows (32-bit) (January 28, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 389, 7, 101, "Title"],
Cell[CellGroupData[{
Cell[993, 33, 227, 5, 86, "Section"],
Cell[CellGroupData[{
Cell[1245, 42, 275, 4, 31, "Input"],
Cell[CellGroupData[{
Cell[1545, 50, 775, 11, 43, "Print"],
Cell[2323, 63, 607, 9, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2991, 79, 156, 2, 86, "Section"],
Cell[CellGroupData[{
Cell[3172, 85, 264, 4, 65, "Subsection"],
Cell[3439, 91, 199, 4, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3675, 100, 341, 6, 65, "Subsection"],
Cell[4019, 108, 159, 4, 30, "Text"],
Cell[4181, 114, 629, 17, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4847, 136, 207, 4, 65, "Subsection"],
Cell[5057, 142, 799, 23, 178, "Input"],
Cell[5859, 167, 211, 6, 46, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[6119, 179, 177, 2, 56, "Section"],
Cell[CellGroupData[{
Cell[6321, 185, 188, 3, 65, "Subsection"],
Cell[CellGroupData[{
Cell[6534, 192, 277, 5, 31, "Input"],
Cell[6814, 199, 2949, 80, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9800, 284, 227, 5, 31, "Input"],
Cell[10030, 291, 2355, 63, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12422, 359, 227, 5, 31, "Input"],
Cell[12652, 366, 2386, 64, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15075, 435, 226, 5, 31, "Input"],
Cell[15304, 442, 2419, 66, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17760, 513, 227, 5, 31, "Input"],
Cell[17990, 520, 2415, 66, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20442, 591, 226, 5, 31, "Input"],
Cell[20671, 598, 2752, 75, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23472, 679, 156, 2, 57, "Subsection"],
Cell[CellGroupData[{
Cell[23653, 685, 618, 14, 52, "Input"],
Cell[24274, 701, 517, 10, 25, "Message"],
Cell[24794, 713, 1200, 33, 74, "Output"]
}, Open  ]],
Cell[26009, 749, 289, 5, 30, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26347, 760, 307, 4, 86, "Section"],
Cell[CellGroupData[{
Cell[26679, 768, 186, 3, 65, "Subsection"],
Cell[CellGroupData[{
Cell[26890, 775, 331, 6, 31, "Input"],
Cell[27224, 783, 3354, 94, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30615, 882, 251, 5, 31, "Input"],
Cell[30869, 889, 2724, 76, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33630, 970, 251, 5, 31, "Input"],
Cell[33884, 977, 2756, 76, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36677, 1058, 248, 5, 31, "Input"],
Cell[36928, 1065, 2712, 76, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39677, 1146, 249, 5, 31, "Input"],
Cell[39929, 1153, 2771, 79, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42737, 1237, 250, 5, 31, "Input"],
Cell[42990, 1244, 3140, 90, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46179, 1340, 156, 2, 57, "Subsection"],
Cell[CellGroupData[{
Cell[46360, 1346, 620, 14, 52, "Input"],
Cell[46983, 1362, 517, 10, 25, "Message"],
Cell[47503, 1374, 1042, 30, 74, "Output"]
}, Open  ]],
Cell[48560, 1407, 266, 5, 30, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48875, 1418, 282, 4, 86, "Section"],
Cell[CellGroupData[{
Cell[49182, 1426, 188, 3, 65, "Subsection"],
Cell[CellGroupData[{
Cell[49395, 1433, 305, 6, 31, "Input"],
Cell[49703, 1441, 1125, 28, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50865, 1474, 251, 5, 31, "Input"],
Cell[51119, 1481, 907, 24, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52063, 1510, 251, 5, 31, "Input"],
Cell[52317, 1517, 866, 22, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53220, 1544, 248, 5, 31, "Input"],
Cell[53471, 1551, 884, 22, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54392, 1578, 251, 5, 31, "Input"],
Cell[54646, 1585, 896, 23, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55579, 1613, 248, 5, 31, "Input"],
Cell[55830, 1620, 949, 25, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56828, 1651, 156, 2, 57, "Subsection"],
Cell[CellGroupData[{
Cell[57009, 1657, 672, 15, 52, "Input"],
Cell[57684, 1674, 495, 10, 25, "Message"],
Cell[58182, 1686, 460, 13, 31, "Output"]
}, Open  ]],
Cell[58657, 1702, 222, 4, 30, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
